<?php
session_start();
require_once __DIR__ . '/../../config.php';

header('Content-Type: application/json');

if (!function_exists('chat_db')) {
    http_response_code(500);
    echo json_encode(['error' => 'config_error', 'message' => 'chat_db() is not defined. Run install.php first.']);
    exit;
}

$pdo = chat_db();
if (!$pdo) {
    http_response_code(500);
    echo json_encode(['error' => 'db_error']);
    exit;
}


if (empty($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'not_logged_in']);
    exit;
}

$me             = (int) $_SESSION['user_id'];
$conversationId = (int) ($_POST['conversation_id'] ?? 0);
$body           = trim($_POST['body'] ?? '');
$body           = mb_substr($body, 0, 2000);

if ($conversationId <= 0 || $body === '') {
    http_response_code(400);
    echo json_encode(['error' => 'invalid_input']);
    exit;
}

// load conversation
$st = $pdo->prepare("SELECT user1_id,user2_id FROM conversations WHERE id = :id");
$st->execute([':id' => $conversationId]);
$conv = $st->fetch();

if (!$conv || ($conv['user1_id'] != $me && $conv['user2_id'] != $me)) {
    http_response_code(403);
    echo json_encode(['error' => 'no_access']);
    exit;
}

$pdo->beginTransaction();

$st = $pdo->prepare("INSERT INTO messages (conversation_id, sender_id, body) VALUES (:cid,:sid,:body)");
$st->execute([
    ':cid'  => $conversationId,
    ':sid'  => $me,
    ':body' => $body,
]);
$msgId = (int)$pdo->lastInsertId();

// update conversation stats
$user1 = (int)$conv['user1_id'];
$user2 = (int)$conv['user2_id'];

if ($me === $user1) {
    $sql = "UPDATE conversations
            SET last_message_id = :mid,
                unread_user2 = unread_user2 + 1,
                updated_at = NOW()
            WHERE id = :cid";
} else {
    $sql = "UPDATE conversations
            SET last_message_id = :mid,
                unread_user1 = unread_user1 + 1,
                updated_at = NOW()
            WHERE id = :cid";
}

$st2 = $pdo->prepare($sql);
$st2->execute([':mid' => $msgId, ':cid' => $conversationId]);

$pdo->commit();

echo json_encode([
    'ok' => true,
    'message' => [
        'id' => $msgId,
        'conversation_id' => $conversationId,
        'sender_id' => $me,
        'body' => $body,
        'status' => 'sent',
        'created_at' => date('Y-m-d H:i:s'),
    ],
]);
