<?php
session_start();
require_once __DIR__ . '/../../config.php';

header('Content-Type: application/json');

if (!function_exists('chat_db')) {
    http_response_code(500);
    echo json_encode(['error' => 'config_error', 'message' => 'chat_db() is not defined. Run install.php first.']);
    exit;
}

$pdo = chat_db();
if (!$pdo) {
    http_response_code(500);
    echo json_encode(['error' => 'db_error']);
    exit;
}


if (empty($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'not_logged_in']);
    exit;
}

$me    = (int) $_SESSION['user_id'];
$typing = !empty($_POST['typing']) ? 1 : 0;

$st = $pdo->prepare("INSERT INTO user_presence (user_id,last_active,is_typing)
                     VALUES (:uid,NOW(),:typing)
                     ON DUPLICATE KEY UPDATE last_active = NOW(), is_typing = :typing");
$st->execute([':uid' => $me, ':typing' => $typing]);

echo json_encode(['ok' => true]);
