<?php
session_start();
require_once __DIR__ . '/../../config.php';

header('Content-Type: application/json');

if (!function_exists('chat_db')) {
    http_response_code(500);
    echo json_encode(['error' => 'config_error', 'message' => 'chat_db() is not defined. Run install.php first.']);
    exit;
}

$pdo = chat_db();
if (!$pdo) {
    http_response_code(500);
    echo json_encode(['error' => 'db_error']);
    exit;
}


if (empty($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'not_logged_in']);
    exit;
}

$me             = (int) $_SESSION['user_id'];
$conversationId = (int) ($_POST['conversation_id'] ?? 0);
$action         = $_POST['action'] ?? ''; // pin|unpin|archive|unarchive

if ($conversationId <= 0 || !in_array($action, ['pin','unpin','archive','unarchive'], true)) {
    http_response_code(400);
    echo json_encode(['error' => 'invalid_input']);
    exit;
}

$st = $pdo->prepare("SELECT user1_id,user2_id FROM conversations WHERE id = :id");
$st->execute([':id' => $conversationId]);
$conv = $st->fetch();

if (!$conv || ($conv['user1_id'] != $me && $conv['user2_id'] != $me)) {
    http_response_code(403);
    echo json_encode(['error' => 'no_access']);
    exit;
}

$field = '';
$value = 0;

if ($action === 'pin' || $action === 'unpin') {
    $field = ($me == (int)$conv['user1_id']) ? 'pinned_user1' : 'pinned_user2';
    $value = ($action === 'pin') ? 1 : 0;
} else {
    $field = ($me == (int)$conv['user1_id']) ? 'archived_user1' : 'archived_user2';
    $value = ($action === 'archive') ? 1 : 0;
}

$sql = "UPDATE conversations SET {$field} = :val WHERE id = :cid";

$st2 = $pdo->prepare($sql);
$st2->execute([':val' => $value, ':cid' => $conversationId]);

echo json_encode(['ok' => true]);
