<?php
session_start();
require_once __DIR__ . '/../../config.php';

header('Content-Type: application/json');

if (!function_exists('chat_db')) {
    http_response_code(500);
    echo json_encode(['error' => 'config_error', 'message' => 'chat_db() is not defined. Run install.php first.']);
    exit;
}

$pdo = chat_db();
if (!$pdo) {
    http_response_code(500);
    echo json_encode(['error' => 'db_error']);
    exit;
}


if (empty($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'not_logged_in']);
    exit;
}

$me     = (int) $_SESSION['user_id'];
$filter = $_GET['filter'] ?? 'all'; // all | unread

$sql = "SELECT c.id,
               c.user1_id,
               c.user2_id,
               c.last_message_id,
               c.unread_user1,
               c.unread_user2,
               c.pinned_user1,
               c.pinned_user2,
               c.archived_user1,
               c.archived_user2,
               m.body AS last_body,
               m.created_at AS last_created_at,
               m.status AS last_status,
               u.id   AS other_id,
               u_name.name AS other_name,
               u_avatar.avatar AS other_avatar
        FROM conversations c
        JOIN messages m ON m.id = c.last_message_id
        JOIN (
            SELECT id, name FROM users
        ) AS u_name ON u_name.id = CASE WHEN c.user1_id = :me THEN c.user2_id ELSE c.user1_id END
        LEFT JOIN (
            SELECT id, avatar FROM users
        ) AS u_avatar ON u_avatar.id = u_name.id
        JOIN users u ON u.id = u_name.id
        WHERE (c.user1_id = :me OR c.user2_id = :me)";

$params = [':me' => $me];

if ($filter === 'unread') {
    $sql .= " AND ((c.user1_id = :me AND c.unread_user1 > 0) OR (c.user2_id = :me AND c.unread_user2 > 0))";
}

$sql .= " ORDER BY
          CASE WHEN (c.user1_id = :me AND c.pinned_user1 = 1) OR (c.user2_id = :me AND c.pinned_user2 = 1)
               THEN 0 ELSE 1 END,
          m.created_at DESC
          LIMIT 100";

$st = $pdo->prepare($sql);
$st->execute($params);
$rows = $st->fetchAll();

$list = [];
foreach ($rows as $r) {
    $unread    = ($r['user1_id'] == $me) ? (int)$r['unread_user1'] : (int)$r['unread_user2'];
    $pinned    = ($r['user1_id'] == $me) ? (int)$r['pinned_user1'] : (int)$r['pinned_user2'];
    $archived  = ($r['user1_id'] == $me) ? (int)$r['archived_user1'] : (int)$r['archived_user2'];

    $list[] = [
        'conversation_id' => (int)$r['id'],
        'other_user_id'   => (int)$r['other_id'],
        'name'            => $r['other_name'],
        'avatar'          => $r['other_avatar'],
        'last_message'    => $r['last_body'],
        'last_time'       => $r['last_created_at'],
        'last_status'     => $r['last_status'],
        'unread'          => $unread,
        'pinned'          => $pinned,
        'archived'        => $archived,
    ];
}

echo json_encode(['conversations' => $list]);
