<?php
session_start();
require_once __DIR__ . '/../../config.php';

header('Content-Type: application/json');

if (!function_exists('chat_db')) {
    http_response_code(500);
    echo json_encode(['error' => 'config_error', 'message' => 'chat_db() is not defined. Run install.php first.']);
    exit;
}

$pdo = chat_db();
if (!$pdo) {
    http_response_code(500);
    echo json_encode(['error' => 'db_error']);
    exit;
}


if (empty($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'not_logged_in']);
    exit;
}

$otherId = (int) ($_GET['other_user_id'] ?? 0);
if ($otherId <= 0) {
    http_response_code(400);
    echo json_encode(['error' => 'invalid_other']);
    exit;
}

$st = $pdo->prepare("SELECT last_active,is_typing FROM user_presence WHERE user_id = :uid");
$st->execute([':uid' => $otherId]);
$row = $st->fetch();

if (!$row) {
    echo json_encode(['online' => false, 'typing' => false, 'last_active' => null]);
    exit;
}

$lastActive = strtotime($row['last_active']);
$online = (time() - $lastActive) < 120; // last 2 minutes

echo json_encode([
    'online'      => $online,
    'typing'      => (bool)$row['is_typing'],
    'last_active' => $row['last_active'],
]);
