<?php
session_start();
require_once __DIR__ . '/../../config.php';

header('Content-Type: application/json');

if (!function_exists('chat_db')) {
    http_response_code(500);
    echo json_encode(['error' => 'config_error', 'message' => 'chat_db() is not defined. Run install.php first.']);
    exit;
}

$pdo = chat_db();
if (!$pdo) {
    http_response_code(500);
    echo json_encode(['error' => 'db_error']);
    exit;
}


if (empty($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'not_logged_in']);
    exit;
}

$me             = (int) $_SESSION['user_id'];
$conversationId = (int) ($_GET['conversation_id'] ?? 0);
$sinceId        = (int) ($_GET['since_id'] ?? 0);

if ($conversationId <= 0) {
    http_response_code(400);
    echo json_encode(['error' => 'invalid_input']);
    exit;
}

$st = $pdo->prepare("SELECT user1_id,user2_id FROM conversations WHERE id = :id");
$st->execute([':id' => $conversationId]);
$conv = $st->fetch();

if (!$conv || ($conv['user1_id'] != $me && $conv['user2_id'] != $me)) {
    http_response_code(403);
    echo json_encode(['error' => 'no_access']);
    exit;
}

if ($sinceId > 0) {
    $sql = "SELECT * FROM messages
            WHERE conversation_id = :cid AND id > :sid
            ORDER BY id ASC
            LIMIT 100";
    $params = [':cid' => $conversationId, ':sid' => $sinceId];
} else {
    $sql = "SELECT * FROM messages
            WHERE conversation_id = :cid
            ORDER BY id DESC
            LIMIT 50";
    $params = [':cid' => $conversationId];
}

$st = $pdo->prepare($sql);
$st->execute($params);
$rows = $st->fetchAll();

if ($sinceId === 0) {
    $rows = array_reverse($rows);
}

echo json_encode(['messages' => $rows]);
