<?php
session_start();
require_once __DIR__ . '/../../config.php';

header('Content-Type: application/json');

if (!function_exists('chat_db')) {
    http_response_code(500);
    echo json_encode(['error' => 'config_error', 'message' => 'chat_db() is not defined. Run install.php first.']);
    exit;
}

$pdo = chat_db();
if (!$pdo) {
    http_response_code(500);
    echo json_encode(['error' => 'db_error']);
    exit;
}


if (empty($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'not_logged_in']);
    exit;
}

$me    = (int) ($_SESSION['user_id']);
$other = (int) ($_POST['other_user_id'] ?? 0);

if ($other <= 0 || $other === $me) {
    http_response_code(400);
    echo json_encode(['error' => 'invalid_other']);
    exit;
}

// store pair sorted
$user1 = min($me, $other);
$user2 = max($me, $other);

$st = $pdo->prepare("SELECT id FROM conversations WHERE user1_id = :u1 AND user2_id = :u2 LIMIT 1");
$st->execute([':u1' => $user1, ':u2' => $user2]);
$row = $st->fetch();

if ($row) {
    echo json_encode(['conversation_id' => (int)$row['id']]);
    exit;
}

$st = $pdo->prepare("INSERT INTO conversations (user1_id, user2_id) VALUES (:u1, :u2)");
$st->execute([':u1' => $user1, ':u2' => $user2]);
$cid = (int)$pdo->lastInsertId();

echo json_encode(['conversation_id' => $cid]);
